#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.3.8.0
 Script name:    VIB2ZIP-GetParams.au3
 Script version: 1.1
 Author:         Andreas Peetz (ESXi5-CPT@v-front.de)

 Script Function:
	Get the parameters for VIB2ZIP

 License: This source code and its compiled executable are licensed
          under the GNU GPL v3. A copy of the license terms is included
		  in the file GPL-v3.txt

#ce ----------------------------------------------------------------------------

#AutoIt3Wrapper_Res_FileVersion=1.1
#AutoIt3Wrapper_Res_ProductVersion=2.1
#AutoIt3Wrapper_Res_LegalCopyright=(C) Andreas Peetz, licensed under the GNU GPL v3
#AutoIt3Wrapper_Res_Description=VIB2ZIP Get Parameters GUI
#AutoIt3Wrapper_Res_Field=ProductName|ESXi5 Community Packaging Tools
#AutoIt3Wrapper_Res_Field=ProductVersion|2.1
#AutoIt3Wrapper_Res_Language=1033

#NoTrayIcon
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <EditConstants.au3>
#Include <GuiEdit.au3>

Opt("GuiCoordMode",0)
Opt("GuiResizeMode", $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKSIZE)

if $CmdLine[0] <> 1 Then
	MsgBox(0, "Error", "Usage: " & @ScriptName & " <file-to-store-parameters>")
	Exit(2)
EndIf

$IniFile = @AppDataDir & "\VIB2ZIP.ini"

; Create the GUI elements
$GUI = GUICreate("VIB2ZIP - ESXi5-CPT.v-front.de", 500, 420, 250, 250, $WS_CAPTION + $WS_SYSMENU + $WS_MINIMIZEBOX + $WS_SIZEBOX)
GUICtrlCreateLabel("Select the source VIB directory (all VIB files located here will be added to the Offline Bundle):", 10, 10, 480)
$VD_Browse = GUICtrlCreateButton(" Browse... ", 0, 18)
GUICtrlSetTip(-1, "Click to browse for the directory containing the VIB files to package.")
$VD_Input = GUICtrlCreateInput("", 65, 3, 410, 20, $ES_LEFT)
GUICtrlCreateLabel("Select the working directory (for temporary data and storage of the resulting Offline Bundle):", -65, 30, 480)
$WD_Browse = GUICtrlCreateButton(" Browse... ", 0, 18)
GUICtrlSetTip(-1, "Click to change the working directory (used for temp files, the log file and the output)")
$WD_Input = GUICtrlCreateInput("", 65, 3, 410, 20, $ES_LEFT)

$advEdit = GUICtrlCreateCheckbox("Pause execution for advanced editing", -64, 30)
GUICtrlSetTip(-1, "Only for experienced users who understand the" & @LF & "format of the metadata XML files")

$updateCheck = GUICtrlCreateCheckbox("Enable automatic update check (requires working Internet connection)", 0, 20)
GUICtrlSetTip(-1, "Please disable this only if you do not have a working Internet connection.")

GUICtrlCreateLabel("Enter Offline Bundle metadata:",174,40)

GUICtrlCreateLabel("Name/ID:",-175,30)
$obName = GUICtrlCreateInput("", 65, -3, 240, 20, $ES_LEFT)
GUICtrlSetTip(-1, "Enter a name for the Offline Bundle.")
GUICtrlCreateLabel("(bundle name)",250,3)

GUICtrlCreateLabel("Version:",-315,30)
$obVersion = GUICtrlCreateInput("", 65, -3, 240, 20, $ES_LEFT)
GUICtrlSetTip(-1, "Enter the version of the Offline Bundle.")
GUICtrlCreateLabel("(e.g. 1.0.0-1)",250,3)

GUICtrlCreateLabel("Vendor:",-315,30)
$obVendor = GUICtrlCreateInput("", 65, -3, 240, 20, $ES_LEFT)
GUICtrlSetTip(-1, "Enter the name of the software vendor or author.")
GUICtrlCreateLabel("(e.g. your name or nick)",250,3)

GUICtrlCreateLabel("Description:",-315,30)
$obDescription = GUICtrlCreateInput("", 65, -3, 240, 20, $ES_LEFT + $ES_AUTOHSCROLL)
GUICtrlSetTip(-1, "Enter the subject or purpose of the software package.")
GUICtrlCreateLabel("(bundle description)",250,3)

GUICtrlCreateLabel("KB-URL:",-315,30)
$obKBURL = GUICtrlCreateInput("", 65, -3, 240, 20, $ES_LEFT)
GUICtrlSetTip(-1, "Enter a URL for useful information, documentation etc. (optional)")
GUICtrlCreateLabel("(URL of your web page, optional)",250,3)

GUICtrlCreateLabel("Contact:",-315,30)
$obContact = GUICtrlCreateInput("", 65, -3, 240, 20, $ES_LEFT)
GUICtrlSetTip(-1, "Enter a contact E-mail address (optional).")
GUICtrlCreateLabel("(Contact E-mail address, optional)",250,3)

$Launcher = GUICtrlCreateButton(" Run! ", -130, 30)
GUICtrlSetTip(-1, "Press Run! to start the build process.")
$Canceler = GUICtrlCreateButton(" Cancel ", 60, 0)
GUICtrlSetTip(-1, "Press Cancel to quit without building.")

; Set initial GUI controls' state
GUICtrlSetState($VD_Input, $GUI_DISABLE)
GUICtrlSetState($WD_Input, $GUI_DISABLE)
GUICtrlSetState($Launcher, $GUI_DISABLE)

; Load last settings from ini-file
$vibDir = IniRead($IniFile, "Settings", "vibDir", "")
if $vibDir = "" OR NOT FileExists($vibDir) Then $vibDir = @MyDocumentsDir
GUICtrlSetData($VD_Input, $vibDir)
$WorkDir = IniRead($IniFile, "Settings", "wDir", "")
if $WorkDir = "" OR NOT FileExists($WorkDir) Then $WorkDir = @MyDocumentsDir
GUICtrlSetData($WD_Input, $WorkDir)
if IniRead($IniFile, "Settings", "advEdit", "0") = "1" Then GUICtrlSetState($advEdit,$GUI_CHECKED)
if IniRead($IniFile, "Settings", "updateCheck", "1") = "1" Then GUICtrlSetState($updateCheck,$GUI_CHECKED)
GUICtrlSetData($obName, IniRead($IniFile, "Settings", "obName", ""))
GUICtrlSetData($obVersion, IniRead($IniFile, "Settings", "obVersion", ""))
GUICtrlSetData($obVendor, IniRead($IniFile, "Settings", "obVendor", ""))
GUICtrlSetData($obDescription, IniRead($IniFile, "Settings", "obDescription", ""))
GUICtrlSetData($obKBURL, IniRead($IniFile, "Settings", "obKBURL", ""))
GUICtrlSetData($obContact, IniRead($IniFile, "Settings", "obContact", ""))

; characters not allowed in file names (will cause errors in the script)
$InvalidChars = "%&!"
; characters allowed in attributes
$AllowedChars = "[:alnum:]-_."

; function to test a filename for invalid characters
Func TestInvalidFilenameChars($testString)
	if StringRegExp($testString,"[" & $InvalidChars & "]") Then
		MsgBox(0,"Invalid character in file name", "The name of the selected file contains an invalid character (" & $InvalidChars & ") that will cause errors with the script. Please rename the file and re-select it!")
		return 1
	Else
		return 0
	EndIf
EndFunc

; function to test for invalid chars in attributes
Func TestInvalidAttrChars($testString, $attrName)
	if StringRegExp($testString,"[^" & $AllowedChars & "]") Then
		MsgBox(0,"Invalid character in Offline Bundle attribute: " & $attrName, "For the attributes Name, Version and Vendor only the following characters are allowed: a-z, A-Z, 0-9, ., - and _")
		return 1
	Else
		return 0
	EndIf
EndFunc

; Show the GUI
GUISetState()

_GUICtrlEdit_SetSel($obDescription, 0, 0)

$focus = ""
; Get and react on messages
While 1
	; Enable the Run-Button if all parameters are set
	If GUICtrlRead($VD_Input) <> "" AND GUICtrlRead($WD_Input) <> "" AND GUICtrlRead($obName) <> "" AND GUICtrlRead($obVersion) <> "" AND GUICtrlRead($obVendor) <> "" AND GUICtrlRead($obDescription) <> "" Then
		if BitAnd(GuiCtrlGetState($Launcher), $GUI_DISABLE) > 0 Then GUICtrlSetState($Launcher, $GUI_ENABLE)
	Else
		if BitAnd(GuiCtrlGetState($Launcher), $GUI_ENABLE) > 0 Then GUICtrlSetState($Launcher, $GUI_DISABLE)
	EndIf
	; Get message
	$msg = GUIGetMsg()
	$newfocus = ControlGetFocus("")
	; If focus has changed ...:
	if $focus <> $newfocus Then
		; if "Description" control lost focus then scroll it to the left:
		if $focus = "Edit6" Then _GUICtrlEdit_SetSel($obDescription, 0, 0)
		$focus = $newfocus
	EndIf
	Select
		; Cancel button clicked
		case $msg = $Canceler OR $msg = $GUI_EVENT_CLOSE
			$ExitCode = 1
			ExitLoop
		; Browse for VIB dir
		case $msg = $VD_Browse
			$vibDir = GUICtrlRead($VD_Input)
			if $vibDir = "" Then
				$vibDirBrowse = @MyDocumentsDir
			Else
				$vibDirBrowse = $vibDir
			EndIf
			$VD_Selection = FileSelectFolder("Select the source VIB directory:", "", 1+2, $vibDirBrowse)
			if $VD_Selection <> "" AND Not TestInvalidFilenameChars($VD_Selection) Then GUICtrlSetData($VD_Input, $VD_Selection)
		; Browse for working dir
		case $msg = $WD_Browse
			$WorkDir = GuiCtrlRead($WD_Input)
			If $WorkDir = "" Then
				$WorkDirBrowse = @MyDocumentsDir
			Else
				$WorkDirBrowse = $WorkDir
			EndIf
			$WD_Selection = FileSelectFolder("Select the working directory:", "", 1+2, $WorkDirBrowse)
			if $WD_Selection <> "" AND Not TestInvalidFilenameChars($WD_Selection) Then GUICtrlSetData($WD_Input, $WD_Selection)
		; Run button clicked
		case $msg = $Launcher
			If TestInvalidAttrChars(GUICtrlRead($obName), "Name") Then ContinueLoop
			If TestInvalidAttrChars(GUICtrlRead($obVersion), "Version") Then ContinueLoop
			If TestInvalidAttrChars(GUICtrlRead($obVendor), "Vendor") Then ContinueLoop
			IniWrite($IniFile, "Settings", "vibDir", GUICtrlRead($VD_Input))
			IniWrite($IniFile, "Settings", "wDir", GUICtrlRead($WD_Input))
			If GUICtrlRead($advEdit) = $GUI_CHECKED Then
				$advEdit_Flag = "1"
			Else
				$advEdit_Flag = "0"
			EndIf
			IniWrite($IniFile, "Settings", "advEdit", $advEdit_Flag)
			If GUICtrlRead($updateCheck) = $GUI_CHECKED Then
				$updateCheck_Flag = "1"
			Else
				$updateCheck_Flag = "0"
			EndIf
			IniWrite($IniFile, "Settings", "updateCheck", $updateCheck_Flag)
			IniWrite($IniFile, "Settings", "obName", GUICtrlRead($obName))
			IniWrite($IniFile, "Settings", "obVersion", GUICtrlRead($obVersion))
			IniWrite($IniFile, "Settings", "obVendor", GUICtrlRead($obVendor))
			IniWrite($IniFile, "Settings", "obDescription", GUICtrlRead($obDescription))
			IniWrite($IniFile, "Settings", "obKBURL", GUICtrlRead($obKBURL))
			IniWrite($IniFile, "Settings", "obContact", GUICtrlRead($obContact))
			$parFile = FileOpen($CmdLine[1], 2)
			If $parFile = -1 Then
				MsgBox(0, "Error", "Cannot open output file " & $CmdLine[1])
				$ExitCode = 2
			Else
				FileWriteLine($parFile,"set vibDir=" & GUICtrlRead($VD_Input))
				FileWriteLine($parFile,"set wDir=" & GUICtrlRead($WD_Input))
				FileWriteLine($parFile,"set advEdit=" & $advEdit_Flag)
				FileWriteLine($parFile,"set updateCheck=" & $updateCheck_Flag)
				FileWriteLine($parFile,"set obName=" & GUICtrlRead($obName))
				FileWriteLine($parFile,"set obVersion=" & GUICtrlRead($obVersion))
				FileWriteLine($parFile,"set obVendor=" & GUICtrlRead($obVendor))
				FileWriteLine($parFile,"set obDescription=" & GUICtrlRead($obDescription))
				FileWriteLine($parFile,"set obKBURL=" & GUICtrlRead($obKBURL))
				FileWriteLine($parFile,"set obContact=" & GUICtrlRead($obContact))
				FileClose($parFile)
				$ExitCode = 0
			EndIf
			ExitLoop
	EndSelect
WEnd

GUIDelete()

Exit($ExitCode)