/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends GraphicObject {
    Image[] pixels;
    Image[] mask;
    int x;
    int y;
    int frame;
    int collx;
    int colly;
    int collw;
    int collh;

    public Sprite(byte[] pixels, int pixel_offset, int width, int height, byte[] mask, int mask_offset, int numFrames) {
        this(com.siemens.mp.ui.Image.createImageFromBitmap(pixels, mask, width, height * numFrames), com.siemens.mp.ui.Image.createImageFromBitmap(mask, width, height * numFrames), numFrames);
    }

    public Sprite(ExtendedImage pixels, ExtendedImage mask, int numFrames) {
        this(pixels.getImage(), mask.getImage(), numFrames);
    }

    public Sprite(Image pixels, Image mask, int numFrames) {
        Image img;
        int i;
        this.pixels = new Image[numFrames];
        for (i = 0; i < numFrames; ++i) {
            img = Image.createImage((int)pixels.getWidth(), (int)(pixels.getHeight() / numFrames));
            img.getGraphics().drawImage(pixels, 0, -i * pixels.getHeight() / numFrames, 0);
            this.pixels[i] = img;
        }
        if (mask != null) {
            this.mask = new Image[numFrames];
            for (i = 0; i < numFrames; ++i) {
                img = Image.createImage((int)mask.getWidth(), (int)(mask.getHeight() / numFrames));
                img.getGraphics().drawImage(mask, 0, -i * mask.getHeight() / numFrames, 0);
                this.mask[i] = img;
            }
        }
        this.collx = 0;
        this.colly = 0;
        this.collw = this.pixels[0].getWidth();
        this.collh = this.pixels[0].getHeight();
    }

    public int getFrame() {
        return this.frame;
    }

    public int getXPosition() {
        return this.x;
    }

    public int getYPosition() {
        return this.y;
    }

    public boolean isCollidingWith(Sprite other) {
        return false;
    }

    public boolean isCollidingWithPos(int xpos, int ypos) {
        return xpos >= this.x + this.collx && xpos < this.x + this.collw && ypos >= this.y + this.colly && ypos < this.y + this.collh;
    }

    public void setCollisionRectangle(int x, int y, int width, int height) {
        this.collx = x;
        this.colly = y;
        this.collw = width;
        this.collh = height;
    }

    public void setFrame(int framenumber) {
        this.frame = framenumber;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    protected void paint(Graphics g) {
        g.drawImage(this.pixels[this.frame], this.x, this.y, 0);
    }
}

