/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.midp.examples.simpledemo;

import javax.microedition.lcdui.Graphics;
import org.microemu.midp.examples.simpledemo.BaseExamplesCanvas;
import org.microemu.midp.examples.simpledemo.SimpleDemoMIDlet;
import org.microemu.midp.examples.simpledemo.Utils;

public class PointerCanvasPanel
extends BaseExamplesCanvas {
    int ppX;
    int ppY;
    int poX;
    int poY;
    String lastPointerEvent = null;
    boolean pointerPressed = false;

    public PointerCanvasPanel() {
        super("PointerCanvas");
    }

    protected void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setGrayScale(255);
        g.fillRect(0, 0, width, height);
        g.setColor(0);
        int line = 0;
        this.writeln(g, line++, "Pointer Canvas");
        if (this.fullScreenMode) {
            this.writeln(g, line++, "Back - Press any key");
        }
        if (!this.hasPointerEvents()) {
            this.writeln(g, line++, "Do not have PointerEvents");
        } else {
            if (!this.hasPointerMotionEvents()) {
                this.writeln(g, line++, "Do not have PointerMotionEvents");
            }
            if (this.lastPointerEvent != null) {
                this.writeln(g, line++, this.ppX + "x" + this.ppY + " " + this.lastPointerEvent);
                if (this.pointerPressed) {
                    g.setColor(0xFFEE99);
                    g.setStrokeStyle(1);
                } else {
                    g.setColor(5673456);
                }
                g.drawRect(this.poX, this.poY, this.ppX - this.poX, this.ppY - this.poY);
                g.setStrokeStyle(0);
                g.setColor(0xBB5500);
                g.drawLine(this.ppX - 3, this.ppY + 3, this.ppX + 3, this.ppY - 3);
                g.drawLine(this.ppX - 3, this.ppY - 3, this.ppX + 3, this.ppY + 3);
            } else {
                this.writeln(g, line++, "Click anywhere and drag");
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.lastPointerEvent = "Pressed " + Utils.when();
        this.ppX = x;
        this.ppY = y;
        this.poX = x;
        this.poY = y;
        this.pointerPressed = true;
        this.repaint();
    }

    public void pointerReleased(int x, int y) {
        this.lastPointerEvent = "Released " + Utils.when();
        this.ppX = x;
        this.ppY = y;
        this.pointerPressed = false;
        this.repaint();
    }

    public void pointerDragged(int x, int y) {
        this.lastPointerEvent = "Dragged " + Utils.when();
        this.ppX = x;
        this.ppY = y;
        this.repaint();
    }

    protected void keyPressed(int keyCode) {
        if (this.fullScreenMode) {
            this.setFullScreenMode(false);
            this.repaint();
        } else {
            SimpleDemoMIDlet.showMenu();
        }
    }
}

